<?php

declare(strict_types=1);

namespace Erlage\Photogram\Structures;

use Erlage\Photogram\System;

final class TableDataDockContainer
{
    /**
     * Contains deSerialized associative maps of models 
     * @var array[]
     */
    private $dataMaps = array();

    /**
     * Contains primary ids of data rows that are in container 
     * @var string[]
     */
    private $primaryAttributeValues = array();

    /**
     * @var string
     */
    private $tableName;

    /**
     * A data dock container is a wrapper that can manage multiple Data Maps
     * of a single type. multiple containers can be spawned for multiple types
     * and can be loaded in a single DataDock for efficient and easy mgmt
     */
    public function __construct(string $tableName)
    {
        $this -> tableName = $tableName;
    }

    /**
     * Name of the table, as it's in actual database 
     */
    public function getTableName(): string
    {
        return $this -> tableName;
    }

    /**
     * @return array[]
     */
    public function getDataMaps(): array
    {
        return \array_values($this -> dataMaps);
    }

    /**
     * @return string[]
     */
    public function getIds(): array
    {
        return \array_keys($this -> dataMaps);
    }

    /**
     * Whether container contains maps. It also signify that there
     * are some models in dock that are already fetched and ready to dispatch
     */
    public function isPopulated(): bool
    {
        return \count($this -> dataMaps) > 0;
    }

    /**
     * Add a data map(Associatative array) to container. Data map are found
     * in objects that extends AbstractModel and can be a data map can be 
     * retrieved from a model using getDataMap call
     */
    public function addDataMap(array $dataMap): void
    {
        $abstractTableClass = System::getTableClassFromTableName($this -> getTableName());

        $primaryAttributeValue = $dataMap[$abstractTableClass::getPrimaryAttribute()];

        $this -> dataMaps[$primaryAttributeValue] = $dataMap;
    }
}
